﻿%% 1:11 PM Thursday, March 16, 2023
%% Yukio $ convert-ly -e strangers1-7cv.ly
%% Part Vocal;; Start: \hide Staff.BarLine
%%              and end: \undo \hide Staff.BarLine \bar "|." \break 
%%              Don't \score{  \context StaffGroup << 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% If you want to change of color,
%%         then do see! in "define-grobs.scm"(lilypond's system file)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\version "2.24.0"
%% This is system-files and for midi's effect
\include "articulate.ly" %% But here isn't use. See----> midi block
%% for sheet-music
#(set-default-paper-size "letter")
#(set-global-staff-size 18)

VoiceColorBlue = {
                   \override Staff.StaffSymbol.color = #blue
                   \override Staff.LedgerLineSpanner.color = #blue
                   \override Staff.Clef.color = #blue
                   \override Staff.TimeSignature.color = #blue
                   \override Staff.KeySignature.color = #blue
                   \override Staff.BarLine.color = #blue
                   \override Voice.NoteHead.color = #blue
                   \override Voice.Rest.color = #blue
                   \override Voice.Stem.color = #blue
                   \override Voice.Flag.color = #blue
                   \override Voice.Beam.color = #blue
                   \override Voice.Slur.color = #blue
                   \override Voice.PhrasingSlur.color = #blue
                   \override Voice.Tie.color = #blue
                   \override Voice.Dots.color = #blue
                   \override Voice.Script.color = #blue
                   \override Voice.Accidental.color = #blue
                   \override Voice.DynamicLineSpanner.color = #blue
                   \override Voice.DynamicText.color = #blue
                   \override Voice.DynamicTextSpanner.color = #blue
                   \override Voice.TupletNumber.color = #blue
                   \override Voice.TupletBracket.color = #blue
                   \override Voice.BreathingSign.color = #blue
                   \override Voice.PercentRepeat.color = #blue
                   \override Voice.RepeatSlash.color = #blue
}
VoiceColorBlueRevert = {
                   \revert Voice.NoteHead.color
                   \revert Voice.Rest.color
                   \revert Voice.Stem.color
                   \revert Voice.Flag.color
                   \revert Voice.Beam.color
                   \revert Voice.Slur.color
                   \revert Voice.PhrasingSlur.color
                   \revert Voice.Tie.color
                   \revert Voice.Dots.color
                   \revert Voice.Script.color
                   \revert Voice.Accidental.color
                   \revert Voice.DynamicLineSpanner.color
                   \revert Voice.DynamicTextSpanner.color
                   \revert Voice.DynamicText.color
                   \revert Voice.TupletNumber.color
                   \revert Voice.TupletBracket.color
                   \revert Voice.BreathingSign.color
                   \revert Voice.BreathingSign.color
                   \revert Voice.PercentRepeat.color
                   \revert Voice.RepeatSlash.color
}
Solo=^\markup { \with-color #red \box { \pad-around #0.5
                                   {\teeny \italic "Solo"} } }
Tutti=^\markup { \with-color #blue { \override #'(box-padding . 0.5)
                          \override #'(thickness . 2) \rounded-box {
                                   {\teeny \italic "Tutti"} } } }
Shead = { \override Voice.NoteHead.font-size = #3
          \override Voice.NoteHead.style = #'petrucci
          \override Voice.NoteHead.color = #red
          \override Voice.Stem.color = #red
          \override Voice.Flag.color = #red
          \override Voice.Rest.color = #red
          \override Voice.Tie.color = #red
          \override Voice.Dots.color = #red }
SheadE= { \revert Voice.NoteHead.font-size
          \revert Voice.NoteHead.style
          \override Voice.NoteHead.color = #blue
          \override Voice.Stem.color = #blue
          \override Voice.Flag.color = #blue
          \override Voice.Rest.color = #blue
          \override Voice.Tie.color = #blue
          \override Voice.Dots.color = #blue }

\paper {
        %%  ragged-last-bottom = ##f
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%% soprano part %%%%%%%%%%%%%%%%%%%%%
sopranoVoice = { \hide Staff.BarLine
    \autoBeamOff
    \partial 2 r2^\fermata |
%% 1-2
   \time 4/1 e'\breve^\Tutti \melisma e'1 e'8\melismaEnd r2.. |
   r1 \Shead e'4^\Solo fis'4. gis' a'4 b'2.. \SheadE r2.. \bar "||" \break
%% 3-4
   r\breve r2. a'4.^\Tutti a'2 a'8 b'4~\( |
   \time 3/2 b'4 b'2 cis''2.\) |\break
%% 5-8
   e''4 e''8 \Shead fis''4^\Solo gis''4. gis''8 gis'' a''4 ~ |
   a''8 r8 \SheadE gis''2^\Tutti r8 cis''4 d''4. | e''2 r2 e''2 |
   cis''4 b'2 a'4 gis'2 ~ | \break
%% 9-12
   gis'2 r2 cis''2 ~ \melisma | cis''1. ~ |
   cis''8 cis'4. r1\melismaEnd | r1. | \break
%% 13-17
   r2. cis''2. | cis''8 cis''4 cis''4. d''4 e''2 |
   cis'2. r8 b'4 cis''4. | \noBreak
   \tuplet 3/2 {b'4( a' gis')} fis'4( e' d'2) | \noBreak
   r1. | \break
%% 18-21
   d'2( e'8 fis' gis'2) r4 | a'2 cis''4 a'8( gis' fis' e' d'4) ~ |
   d'4 cis'4 r16 cis'8. d'4. r16 fis'8\( a'8.\) | cis''1 r2 | \break
%% 22-25
   d'1.\melisma | d'1. | e''1. | gis''1\melismaEnd r2^\fermata | \break
%% 26-27
   \time 4/1 r\longa  | r\longa | \break
%% 28-
   r\longa | \break
%% 29-32
   \time 3/2
   \Shead cis'''1^\Solo a''8. r16 a''4 ~ |
   a''2. gis''4 fis'' e'' ~ |
   e''8 \SheadE cis''2.^\Tutti cis''4. cis''4 ~ | cis''1 r2 | \break
%% 33-
   r1. | r1. | r1. | r1. | r1. | \break
%% 38-41
   d''2^\fermata r8 b'4. d''2 ~ | d''2 cis''4. b'8 d''4\( e''4 ~ |
   e''1\) r8 cis''4. | a' a'8 cis''2.. r8 | \break
%% 42-46
   r2.. e''2^\fermata r8 | cis''4 a'2. gis'4\(( cis'') | e''1\) r2 |
   r8 e'2..^\fermata cis'4 e'4 ~ |
   e'2 r2 s2
   \once \override Score.RehearsalMark.break-visibility =
                                                   #end-of-line-visible
   \once \override Score.RehearsalMark.self-alignment-X = #RIGHT
   \mark "D.C." \bar "||" \break
%% D.C.
%% Coda--sheet
%% 1-4
   \time 3/2
   r4 e''2 fis''2. | r4 cis'' d''2\( e''2\) | r8 cis''8 e''2.\( e''2 |
   e''2..\) r4  fis'4. | \break
%% 5-8
   << \context Voice = SopranoSolo {
      \Shead fis''4^\Solo gis''4. gis''4 gis''8 a''2 \SheadE } \\ 
      \context Voice = SopranoTutti {
      \VoiceColorBlue cis'2\melisma d' cis'4. d'8\melismaEnd } >> |
   a''2. r4 cis''4 d''4\( | e''1\) cis''4 d'' |
   r8 cis''4.\( b'4 e''2.\) \undo \hide Staff.BarLine \bar "|" \break %% | \break
%%
}
sopranoVoiceL = \lyricmode {
\override Lyrics.LyricText.color = #blue
    \override Lyrics.LyricHyphen.color = #blue
    \override Lyrics.LyricExtender.color = #blue
    \override Score.LyricText.font-shape = #'italic
    \teeny
w __
De -- scend -- ants "of the" Earth
"You are" never a trav -- el -- ler!
"It is" the de -- scend -- ant "of the" Earth life,
"in the" uni -- verse. "It is" that sur -- vi -- vor!
m __

"It is the" de -- scend -- ant "of the" universe
where "it was" "in the" solar system!
Since "we were" de -- stroyed, "in this" uni -- verse un -- til now,
%% What happened? Tell it to us!
m __
Did "it all" reveal root of this? Tell "it to" us!

%% We are life forms that have already been erased from space!
But since life "was given" "by the" uni -- verse,
We have the right!
What is this uni -- verse?
What is we?

You guys are nev -- er a trav -- el -- ler!
"It is the" %% descendant of the Earth
life, "in the" uni -- verse
"It is" that sur -- vi -- vor!
}
SopranoSoloL = \lyricmode {
\override Lyrics.LyricText.color = #red
    \override Lyrics.LyricHyphen.color = #red
    \override Lyrics.LyricExtender.color = #red
    \override Score.LyricText.font-shape = #'italic
    \teeny
De -- scend -- ants "of the" Earth
}
SopranoTuttiL = \lyricmode {
\override Lyrics.LyricText.color = #blue
    \override Lyrics.LyricHyphen.color = #blue
    \override Lyrics.LyricExtender.color = #blue
    \override Score.LyricText.font-shape = #'italic
    \teeny
w __
}
sopranoVoiceM = {
    \autoBeamOff
    \partial 2 r2^\fermata |
%% 1-2
   \time 4/1 e'\breve\melisma e'1 e'8\melismaEnd r2.. |
   r1 e'4 fis'4. gis' a'4 b'2.. r2.. \bar "||" \break
%% 3-4
   r\breve r2. a'4. a'2 a'8 b'4~\( |
   \time 3/2 b'4 b'2 cis''2.\) | \break
%% 5-8
   e''4 e''8 \Shead fis''4^\Solo gis''4. gis''8 gis'' a''4 ~ |
   a''8 r8 \SheadE gis''2^\Tutti r8 cis''4 d''4. | e''2 r2 e''2 |
   cis''4 b'2 a'4 gis'2 ~ | \break
%% 9-12
   gis'2 r2 cis''2 ~ \melisma | cis''1. ~ |
   cis''8 cis'4.\melismaEnd r1 | r1. | \break
%% 13-17
   r2. cis''2. | cis''8 cis''4 cis''4. d''4 e''2 |
   cis'2. r8 b'4 cis''4. | \noBreak
   \tuplet 3/2 {b'4( a' gis')} fis'4( e' d'2) | \noBreak
   r1. | \break
%% 18-21 
   d'2( e'8 fis' gis'2) r4 | a'2 cis''4 a'8( gis' fis' e' d'4) ~ |
   d'4 cis'4 r16 cis'8. d'4. r16 fis'8\( a'8.\) | cis''1 r2 | \break
%% 22-25
   d'1.\melisma | d'1. | e''1. | gis''1\melismaEnd r2^\fermata | \break
%% 26-27
   \time 4/1 r\longa  | r\longa | \break
%% 28-
   r\longa | \break
%% 29-32
   \time 3/2
   \Shead cis'''1^\Solo a''8. r16 a''4 ~ |
   a''2. gis''4 fis'' e'' ~ |
   e''8 \SheadE cis''2.^\Tutti cis''4. cis''4 ~ | cis''1 r2 | \break
%% 33-37
   r1. | r1. | r1. | r1. | r1. | \break
%% 38-41
   d''2^\fermata r8 b'4. d''2 ~ | d''2 cis''4. b'8 d''4\( e''4 ~ |
   e''1\) r8 cis''4. | a' a'8 cis''2.. r8 | \break
%% 42-46
   r2..^\fermata e''2 r8 | cis''4 a'2. gis'4\(( cis'') | e''1\) r2 |
   r8^\fermata e'2.. cis'4 e'4 ~ | e'2 r1 \bar "||" \break
%% D.C. (Re-midi bar 1 and bar 2)
%% Re;
   \skip 1 r2 |
%% Re; 1-2
   \time 4/1 e'\breve\melisma e'1 e'8\melismaEnd r2.. |
   r1 e'4 fis'4. gis' a'4 b'2.. r2.. \bar "||" \break
%% Coda--midi
%% 1-4
   \time 3/2
   r4 e''2 fis''2. | r4 cis'' d''2\( e''2\) | r8 cis''8 e''2.\( e''2 |
   e''2..\) r4  fis'4. | \break
%% 5-8
   << { \Shead fis''4^\Solo gis''4. gis''4 gis''8 a''2 \SheadE } \\
      { cis'2\melisma d' cis'4. d'8\melismaEnd } >> |
   a''2. r4 cis''4 d''4\( | e''1\) cis''4 d'' |
   r8 cis''4.\( b'4 e''2.\) | \break
%% 9-
}
%%%
%%% Instruments part
soprano = {
    \autoBeamOff
    \partial 2 r2^\fermata
%% 1-2
   \time 4/1 e'\breve d'\breve ~ |
   \pitchedTrill d'\longa\startTrillSpan e'
   \once \override Score.RehearsalMark.break-visibility =
                                                   #end-of-line-visible
   \once \override Score.RehearsalMark.self-alignment-X = #RIGHT
   \mark \markup {
            \fontsize #4 {\musicglyph #"scripts.coda"}} \bar "||" \break
%% 3-4
   d'\breve d'8\stopTrillSpan r8 e'1.. ~ | \time 3/2 <e' gis'>1. | \break
%% 5-8
   \pitchedTrill fis'1.\startTrillSpan cis' | gis' | fis' | e' | \break
%% 9-12
   d'1 cis'2\stopTrillSpan ~ | cis'2 r4. <cis' cis''>2 <d' d''>8 ~ |
   <d' d''>8 ~ <d' gis' d''>4. ~ gis'2. cis''4 ~ | cis''1. ~ | \break
%% 13-17
   cis''2 r1 | r1. | r2 e''1 | \noBreak
   d''8.-._( cis''-. b'-. a'-. gis'-. fis'-. e'-. d') ~ | \noBreak
   <d' gis'>4 <e' a'>4. <fis' b'> <gis' cis''>2 ~ | \break
%% 18-21
   cis''2 r1 | r1. | r1. | r1. | \break
%% 22-25
   r1. | r1. | r1. | r1. | \break
%% 26-27
   \time 4/1
   gis''2 r8 <cis'' gis''>2 <d'' fis''>2.. e''\breve ~ |
   e''\breve <fis'' d''>2 <gis'' cis''> gis''1 | \break
%% 28-
   <e'' cis''>8\( <d'' b'> <cis'' a'> <b' gis'> <a' fis'> <gis' e'>
   <fis' d'> cis'\breve\)_\( <cis' fis'>8 <cis' gis'> <cis' a'> <cis' b'>
   <fis' cis''> <gis' d''> <a' e''> <b' fis''> <cis'' gis''>\) ~ | \break
%% 29-32
   \time 3/2
   <cis'' gis''>2 r1 | r1. | r1. | r1. | \break
%% 33-37
   r2 <cis' e'>1^\fermata ~ | <cis' e'>1.\(( | <d' fis'>) ~ | <d' fis'>( |
   <cis' e'>2)\) r1 | \break
%% 38-41
   r1. | r1. | r1. | r1. | \break
%% 42-46
   r1. | r1. | r1. | r1. | r1. | \break
%% D.C.
%% Coda--Sheet
%% 1-4
   \time 3/2
   %% \override Score.BarNumber.break-visibility = ##(#f #f #t)
   \set Score.barNumberVisibility = #all-bar-numbers-visible
   \set Score.currentBarNumber = #1
   \bar ""
   e'4\stopTrillSpan
      ^\markup { \column { \line { Coda-Sheet }
                          "  " "  "
                 \line { \hspace #-4 \fontsize #4 {
                   \musicglyph #"scripts.varcoda"} } " " } }
   r2^\markup { \hspace #6 \fermata }
   \repeat percent 3 { <cis' e'>16 r16 <d' fis'>16 r16 } |
   \repeat percent 12 { r16 <fis' d'>16 r16 <e' cis'>16 } |
   cis'16 d'8 e'8. fis'4 gis'4. a'2 | \break
%% 5-8
   \phrasingSlurDashPattern #0.5 #2.0
   cis'1._\( | b'\)_\( | cis'_\)_\( | b'\)_\( | \break
%% 9-12
   b'1.\) ~ | <cis' b'>2. <e' gis'> | fis'1. ~ | fis' \bar "|." \break
}
%%% end Soprano sheet.
%%%
sopranoM = {
    \autoBeamOff
   \partial 2 r2^\fermata |
%% 1-2
   \time 4/1
   e'\breve d'\breve ~ |
   \pitchedTrill d'\longa\startTrillSpan e' \bar "||" \break
%% 3-4
   d'\breve d'8\stopTrillSpan r8 e'1.. ~ |
   \time 3/2 <e' gis'>1. | \break
%% 5-8
   \pitchedTrill fis'1.\startTrillSpan cis' | gis' | fis' | e' | \break
%% 9-12
   d'1 cis'2\stopTrillSpan ~ | cis'2 r4. <cis' cis''>2 <d' d''>8 ~ |
   <d' d''>8 ~ <d' gis' d''>4. ~ gis'2. cis''4 ~ | cis''1. ~ | \break
%% 13-17
   cis''2 r1 | r1. | r2 e''1 | \noBreak
   d''8.-._( cis''-. b'-. a'-. gis'-. fis'-. e'-. d') ~ | \noBreak
   <d' gis'>4 <e' a'>4. <fis' b'> <gis' cis''>2 ~ | \break
%% 18-21
   cis''2 r1 | r1. | r1. | r1. | \break
%% 22-25
   r1. | r1. | r1. | r1. | \break
%% 26-27
   \time 4/1
   gis''2 r8 <cis'' gis''>2 <d'' fis''>2.. e''\breve ~ |
   e''\breve <fis'' d''>2 <gis'' cis''> gis''1 | \break
%% 28-
   <e'' cis''>8\( <d'' b'> <cis'' a'> <b' gis'> <a' fis'> <gis' e'>
   <fis' d'> cis'\breve\)_( <cis' fis'>8 <cis' gis'> <cis' a'> <cis' b'>
   <fis' cis''> <gis' d''> <a' e''> <b' fis''> <cis'' gis''>\) ~ | \break
%% 29-32
   \time 3/2
   <cis'' gis''>2 r1 | r1. | r1. | r1. | \break
%% 33-37
   r2 <cis' e'>1^\fermata ~ | <cis' e'>1.\(( | <d' fis'>) ~ | <d' fis'>( |
   <cis' e'>2)\) r1 | \break
%% 38-41
   r1. | r1. | r1. | r1. | \break
%% 42-46
   r1. | r1. | r1. | r1. | r1. \bar "||" \break
%% D.C. (Re-midi bar 1 and bar 2)
%% Re;
   \skip 1 r2 |
%% Re; 1-2
   \time 4/1
   e'\breve d'\breve ~ |
   \pitchedTrill d'\longa\startTrillSpan e' | \break
%% Coda--midi
%% 1-4
   \time 3/2
   e'4\stopTrillSpan r2
   \repeat percent 3 { <cis' e'>16 r16 <d' fis'>16 r16 } |
   \repeat percent 12 { r16 <fis' d'>16 r16 <e' cis'>16 } |
   cis'16 d'8 e'8. fis'4 gis'4. a'2 | \break
%% 5-8
   cis'1._\( | b'\)_\( | cis'_\)_\( | b'\)_\( | \break
%% 9-12
   b'1.\) ~ | <cis' b'>2. <e' gis'> | fis'1. ~ | fis' \bar "|." \break
}
%%% end soprano-midi.
%%%
%%%%%%%%%% alto part %%%%%%%%%%%%%%%%%%%%%
altoVoice = { \hide Staff.BarLine
    \autoBeamOff
   \partial 2 r2^\fermata |
%% 1-2
   \time 4/1 b\breve^\Tutti \melisma b1 b8\melismaEnd r2.. |
   r2 \Shead b4^\Solo cis'4. d' e'4 fis'2.. \SheadE r4. r1 | \break
%% 3-4
   r\breve r2. d'4.^\Tutti d'2  d'8 e'4~\( |
   \time 3/2 e'4 e'2 fis'2.\) | \break
%% 5-8
   a'4 a'8 \Shead b'4^\Solo cis''4. cis''8 cis'' d''4 ~ |
   d''8 r8 \SheadE cis''2^\Tutti r8 fis'4 gis'4. | a'2 r2 a'2 |
   fis'4 e'2 d'4 cis'2 ~ | \break
%% 9-12
   cis'2 r2 cis''2 ~ \melisma | cis''1. ~ |
   cis''8 cis'4. r1\melismaEnd r1. | \break
%% 13-17
   r1 gis'2 | \tuplet 3/2 {gis'4 gis' gis'} gis'8 a'8 b'2. |
   fis2. r8 b4 cis'4. | \noBreak b4.( a) fis2. | \noBreak
   r1. | \break
%% 18-21
   r4 gis1( a4) | d'2 fis'4 d'8( cis' b a gis4) ~ |
   gis4 gis'2 r16 b4. gis8( fis8.) | fis1 r2 | \break
%% 22-25
   gis1.\melisma | gis'1. | a'1. | cis''1\melismaEnd r2^\fermata | \break
%% 26-27
   \time 4/1 r\longa  | r\longa | \break
%% 28-
   r\longa | \break
%% 29-
   \time 3/2
   \Shead fis''1^\Solo e''8. r16 d''4 ~ | d''2. cis''4 b'4 a'4 ~ |
   a'8 \SheadE fis'2.^\Tutti fis'4. fis'4 ~ | fis'1 r2 | \break
%% 33-37
   r1. | r1. | r1. | r1. | r1. | \break
%% 38-41
   d'2^\fermata r8 b4. d'2 ~ | d'2 cis'4. b8 d'4\( e'4 ~ |
   e'1\) r8 cis'4. | a a8 cis'2.. r8 | \break
%% 42-46
   r2. a'2.^\fermata | fis'4 d'4. r4 cis'4\(( fis'4.) |
  a'2.\) r2. | r8 a2..^\fermata fis4 a4 ~ | a2 r2 s2 \bar "||" \break
%% D.C.
%% Coda--sheet
%% 1-4
   \time 3/2
   r4 a'2 b'2. | r4 fis' gis'2\( a'2\) | r8 fis'8 a'2.\( a'2 |
   a'2..\) r4  b4. | \break
%% 5-8
   << \context Voice = AltoSolo {
         \Shead b'4^\Solo cis''4. cis''4 cis''8 d''2 \SheadE } \\
      \context Voice = AltoTutti { \VoiceColorBlue
         fis2\melisma gis2 fis4. gis8\melismaEnd } >> |
   d''2. r4 fis'4 gis'4\( | a'1\) fis'4 gis'4 |
   r8 fis'4.\( e'4 a'2.\) \undo \hide Staff.BarLine \bar "|" \break
%%
}
altoVoiceL = \lyricmode {
    \override Lyrics.LyricText.color = #blue
    \override Lyrics.LyricHyphen.color = #blue
    \override Lyrics.LyricExtender.color = #blue
    \override Score.LyricText.font-shape = #'italic
    \teeny
w __
De -- scend -- ants "of the" Earth
"You are" never a trav -- el -- ler!
"It is" the de -- scend -- ant "of the" Earth life,
"in the" uni -- verse. "It is" that sur -- vi -- vor!
m __

"It is the" de -- scend -- ant of the universe
where "it was" "in the" solar system!
Since "we were" de -- stroyed, "in this" universe until now,
%% What happened? Tell it to us!
m __
Did "it all" reveal root of this? Tell "it to" us!

%% We are life forms that have already been erased from space!
But since life "was given" "by the" uni -- verse,
We have the right!
What is this uni -- verse?
What is we?

You guys are nev -- er a trav -- el -- ler!
"It is the" %% descendant of the Earth
life, "in the" uni -- verse
"It is" that sur -- vi -- vor!
}
AltoSoloL = \lyricmode {
\override Lyrics.LyricText.color = #red
    \override Lyrics.LyricHyphen.color = #red
    \override Lyrics.LyricExtender.color = #red
    \override Score.LyricText.font-shape = #'italic
    \teeny
De -- scend -- ants "of the" Earth
}
AltoTuttiL = \lyricmode {
\override Lyrics.LyricText.color = #blue
    \override Lyrics.LyricHyphen.color = #blue
    \override Lyrics.LyricExtender.color = #blue
    \override Score.LyricText.font-shape = #'italic
    \teeny
w __
}
altoVoiceM = {
    \autoBeamOff
   \partial 2 r2^\fermata |
%% 1-2
   \time 4/1 b\breve\melisma b1 b8\melismaEnd r2.. |
   r2 b4 cis'4. d' e'4 fis'2.. r4. r1 | \break
%% 3-4
   r\breve r2. d'4. d'2  d'8 e'4~\( |
   \time 3/2 e'4 e'2 fis'2.\) | \break
%% 5-8
   a'4 a'8 \Shead b'4^\Solo cis''4. cis''8 cis'' d''4 ~ |
   d''8 r8 \SheadE cis''2^\Tutti r8 fis'4 gis'4. | a'2 r2 a'2 |
   fis'4 e'2 d'4 cis'2 ~ | \break
%% 9-12
   cis'2 r2 cis''2 ~ \melisma | cis''1. ~ |
   cis''8 cis'4. r1\melismaEnd r1. | \break
%% 13-17
   r1 gis'2 | \tuplet 3/2 {gis'4 gis' gis'} gis'8 a'8 b'2. |
   fis2. r8 b4 cis'4. | \noBreak b4.( a) fis2. | \noBreak
   r1. | \break
%% 18-21
   r4 gis1( a4) | d'2 fis'4 d'8( cis' b a gis4) ~ |
   gis4 gis'2 r16 b4. gis8( fis8.) | fis1 r2 | \break
%% 22-25
   gis1.\melisma | gis'1. | a'1. | cis''1\melismaEnd r2^\fermata | \break
%% 26-27
   \time 4/1 r\longa  | r\longa | \break
%% 28-
   r\longa | \break
%% 29-32
   \time 3/2
   \Shead fis''1^\Solo e''8. r16 d''4 ~ | d''2. cis''4 b'4 a'4 ~ |
   a'8 \SheadE fis'2.^\Tutti fis'4. fis'4 ~ | fis'1 r2 | \break
%% 33-37
   r1. | r1. | r1. | r1. | r1. | \break
%% 38-41
   d'2^\fermata r8 b4. d'2 ~ | d'2 cis'4. b8 d'4\( e'4 ~ |
   e'1\) r8 cis'4. | a a8 cis'2.. r8 | \break
%% 42-46
   r2. a'2.^\fermata | fis'4 d'4. r4 cis'4\(( fis'4.) |
  a'2.\) r2. | r8 a2..^\fermata fis4 a4 ~ | a2 r2 s2 | \break
%% D.C. bar 1 and bar 2
   \skip 1 r2 |
%% 1-2
   \time 4/1 b\breve\melisma b1 b8\melismaEnd r2.. |
   r2 b4 cis'4. d' e'4 fis'2.. r4. r1 | \break
%% Coda-midi
%% 1-4
   \time 3/2
   r4 a'2 b'2. | r4 fis' gis'2\( a'2\) | r8 fis'8 a'2.\( a'2 |
   a'2..\) r4  b4. | \break
%% 5-8
   << { \Shead b'4^\Solo cis''4. cis''4 cis''8 d''2 \SheadE }
   \\ { fis2\melisma gis2 fis4. gis8\melismaEnd } >> |
   d''2. r4 fis'4 gis'4\( | a'1\) fis'4 gis'4 |
   r8 fis'4.\( e'4 a'2.\) | \break
%% 9-
}
%%%
%%% Instruments 
alto = {
     \autoBeamOff
   \partial 2 r2^\fermata |
%% 1-
   \time 4/1 b\breve a\breve ~ |
   \pitchedTrill a\longa\startTrillSpan b | \break
%% 3-4
   a\breve a8\stopTrillSpan r8 b1.. ~ | \time 3/2 <b d'>1. | \break
%% 5-8
   \pitchedTrill b1.\startTrillSpan fis | cis' | b | a | \break
%% 9-12
   gis1 fis2\stopTrillSpan ~ | fis r4. <fis fis'>2 <gis gis'>8 ~ |
   <gis gis'>8 ~ <gis cis' gis'>4. ~ cis'2. fis'4 ~ | fis'1. ~ | \break
%% 13-17
   fis'2 r1 | r1. | r1 e'2 | \noBreak cis'1. ~ | \noBreak
   <gis cis'>1. ~ | \break
%% 18-21
   cis'2 r1 | r1. | r1. | r1. | \break
%% 22-25
   r1. | r1. | r1. | r1. | \break
%% 26-27
   \time 4/1
   cis''2 r8 <cis'' fis'>2 <b' gis'>2.. a'\breve ~ |
   a'\breve <gis' b'>2 <fis' cis''> cis''1 | \break
%% 28-
   <gis b>8_\( <a cis'> <b d'> <cis' e'> <d' fis'> <e' gis'> <fis' a'>
   gis'\breve\)\( <cis'' fis'>8 <b' e'> <a' d'> <gis' cis'> <fis' b>
   <fis e'> <fis d'> <fis cis'> <fis b>\) ~ |
%% 29-32
   \time 3/2
   <fis b>2 r1 | r1. | r1. | r1. | \break
%% 33-37
   r2 <b d'>1^\fermata ~ | <b d'>1._\(_( | <a cis'>) ~ | <a cis'>_( |
   <b d'>2)\) r1 | \break
%% 38-41
   r1. | r1. | r1. | r1. | \break
%% 42-46
   r1. | r1. | r1. | r1. | r1. | \break
%% D.C.
%% Coda--Sheet
%% 1-4
   \time 3/2
   b4\stopTrillSpan <a cis'>2^\fermata <gis d'>2. |
   b2 <a cis'> <gis d'> ~ |
   <gis d'>2. <a cis'>2 b4 ~ | b2. <gis d'> | \break
%% 5-8
   \phrasingSlurDashPattern #0.5 #2.0
   e'1._\( | fis\)_\( | e'\)_\( | fis\)_\( | \break
%% 9-12
   e'1.\) ~ | <fis e'>2. <a cis'> | b1. ~ | b \bar "|." \break
}
%%% end alto sheet
%%%
altoM = {
     \autoBeamOff
   \partial 2 r2^\fermata |
%% 1-2
   \time 4/1 b\breve a\breve ~ |
   \pitchedTrill a\longa\startTrillSpan b | \break
%% 3-4
   a\breve a8\stopTrillSpan r8 b1.. ~ | \time 3/2 <b d'>1. | \break
%% 5-8
   \pitchedTrill b1.\startTrillSpan fis | cis' | b | a | \break
%% 9-12
   gis1 fis2\stopTrillSpan ~ | fis r4. <fis fis'>2 <gis gis'>8 ~ |
   <gis gis'>8 ~ <gis cis' gis'>4. ~ cis'2. fis'4 ~ | fis'1. ~ | \break
%% 13-17
   fis'2 r1 | r1. | r1 e'2 | \noBreak cis'1. ~ | \noBreak
   <gis cis'>1. ~ | \break
%% 18-21
   cis'2 r1 | r1. | r1. | r1. | \break
%% 22-25
   r1. | r1. | r1. | r1. | \break
%% 26-27
   \time 4/1
   cis''2 r8 <cis'' fis'>2 <b' gis'>2.. a'\breve ~ |
   a'\breve <gis' b'>2 <fis' cis''> cis''1 | \break
%% 28-
   <gis b>8_\( <a cis'> <b d'> <cis' e'> <d' fis'> <e' gis'> <fis' a'>
   gis'\breve\)\( <cis'' fis'>8 <b' e'> <a' d'> <gis' cis'> <fis' b>
   <fis e'> <fis d'> <fis cis'> <fis b>\) ~ |
%% 29-32
   \time 3/2
   <fis b>2 r1 | r1. | r1. | r1. | \break
%% 33-37
   r2 <b d'>1^\fermata ~ | <b d'>1._\(_( | <a cis'>) ~ | <a cis'>_( |
   <b d'>2)\) r1 | \break
%% 38-41
   r1. | r1. | r1. | r1. | \break
%% 42-46
   r1. | r1. | r1. | r1. | r1. | \break
%% D.C. (Re-midi bar 1 and bar 2)
%% Re;
   \skip 1 r2 |
%% Re; 1-2
   \time 4/1 b\breve a\breve ~ |
   \pitchedTrill a\longa\startTrillSpan b | \break
%% Coda--midi
%% 1-4
   \time 3/2
   b4\stopTrillSpan <a cis'>2^\fermata <gis d'>2. |
   b2 <a cis'> <gis d'> ~ |
   <gis d'>2. <a cis'>2 b4 ~ | b2. <gis d'> | \break
%% 5-8
   e'1._\( | fis\)_\( | e'\)_\( | fis\)_\( | \break
%% 9-12
   e'1.\) ~ | <fis e'>2. <a cis'> | b1. ~ | b \bar "|." \break
}
%%% end alto-midi
%%%
%%%%%%%% tenor part %%%%%%%%%%%%%%%%%%%%%%%
tenorVoice = { \hide Staff.BarLine
    \autoBeamOff
    \partial 2 r2^\fermata |
%% 1-2
   \time 4/1 fis\breve^\Tutti \melisma fis1 fis8\melismaEnd r2.. |
   \Shead fis4^\Solo gis4. a b4 cis'2.. \SheadE r2.. r1 | \break
%% 3-4
   r\breve r2 b4.^\Tutti b2 b8 cis'2\( |
   \time 3/2 cis'2 d'2.\) r4 | \break
%% 5-8
   fis'4 fis'8 \Shead gis'4^\Solo a'4. a'8 a' b'4 ~ |
   b'8 r8 \SheadE a'2^\Tutti r8 d'4 e'4. | fis'2 r2 fis'2 |
   d'4 cis'2 b4 a2 ~ | \break
%% 9-12
   a2 r2 a'2 ~ \melisma | a'1. ~ | a'8 a4. r1\melismaEnd | r1. | \break
%% 13-17
   r1 fis2 | \tuplet 3/2 {fis4 fis fis} fis8 gis8 a2. | 
   fis2. r8 b4 cis'4. | \noBreak b4.( a) fis2. | \noBreak
   r1. | \break
%% 18-21
   e1.\melisma | a1. | d'1. | d1\melismaEnd r2 | \break
%% 22-25
   d'2 cis'4 b8( a gis4) r4 | r8 gis'2  fis'8 a'2. ~ |
   a'2. r2.^\fermata | r1. | \break
%% 26-27
   \time 4/1 r\longa  | r\longa | \break
%% 28-
   r\longa | \break
%% 29-32
   \time 3/2
   \Shead b'1^\Solo a'8. r16 gis'4 ~ | gis'2. fis'4 e'4 d'4 ~ |
   d'8 \SheadE b2.^\Tutti b4. b4 ~ | b1 r2 | \break
%% 33-37
   r1. | r1 d2^\fermata | d4 d4. r8 e2. | d8 d4 e8 d4. r8 d2 |
   d8( e4.) gis4 e'2. | \break
%% 38-41
   r1. | r1. | r1. | r1. | \break
%% 42-
   r2 d'2.^\fermata b4 | r4 gis4. fis2\( cis'4. ~ |
   cis'4.\) r4. d'2.^\fermata | r4 b gis1 |  r2 s1 \bar "||" \break
%% D.C.
%% Coda--sheet
%% 1-4
   \time 3/2
   r4 fis'2 gis'2. | r4 d'4 e'2\( fis'2\) | r8 d'8 fis'2.\( fis'2 |
   fis'2..\) r4  gis4. | \break
%% 5-8
   << \context Voice = TenorSolo {
         \Shead gis'4^\Solo a'4. a'4 a'8 b'2 \SheadE } \\
      \context Voice = TenorTutti { \VoiceColorBlue
         d2\melisma e2 d4. e8\melismaEnd } >> |
   b'2. r4 d'4 e'4\( | fis'1\) d'4 e'4 |
   r8 d'4.\( cis'4 fis'2.\) \undo \hide Staff.BarLine \bar "|" \break
%%
}
tenorVoiceL = \lyricmode {
    \override Lyrics.LyricText.color = #blue
    \override Lyrics.LyricHyphen.color = #blue
    \override Lyrics.LyricExtender.color = #blue
    \override Score.LyricText.font-shape = #'italic
    \teeny
m __
De -- scend -- ants "of the" Earth
"You are" never a trav -- el -- ler!
"It is" the de -- scend -- ant "of the" Earth life,
"in the" uni -- verse. "It is" that sur -- vi -- vor!
w __

"It is the" de scend -- ant of the universe
where "it was" "in the" solar system!
%% Since we were destroyed, in this universe until now,
w __
What hap -- pened? Tell "it to" us!
Did "it all" reveal root of this? Tell "it to" us!

We are life forms that have al -- ready been erased from space!
%% But since life was given by the universe,
%% We have the right!
What is this uni -- verse?
What is we?

You guys are nev -- er a trav -- el -- ler!
"It is the" %% descendant of the Earth
life, "in the" uni -- verse
"It is" that sur -- vi -- vor!
}
TenorSoloL = \lyricmode {
\override Lyrics.LyricText.color = #red
    \override Lyrics.LyricHyphen.color = #red
    \override Lyrics.LyricExtender.color = #red
    \override Score.LyricText.font-shape = #'italic
    \teeny
De -- scend -- ants "of the" Earth
}
TenorTuttiL = \lyricmode {
\override Lyrics.LyricText.color = #blue
    \override Lyrics.LyricHyphen.color = #blue
    \override Lyrics.LyricExtender.color = #blue
    \override Score.LyricText.font-shape = #'italic
    \teeny
w __
}

tenorVoiceM = {
    \autoBeamOff
    \partial 2 r2^\fermata |
%% 1-2
   \time 4/1 fis\breve\melisma fis1 fis8\melismaEnd r2.. |
   fis4 gis4. a b4 cis'2.. r2.. r1 | \break
%% 3-4
   r\breve r2 b4. b2 b8 cis'2\( | \time 3/2 cis'2 d'2.\) r4 | \break
%% 5-8
   fis'4 fis'8 \Shead gis'4^\Solo a'4. a'8 a' b'4 ~ |
   b'8 r8 \SheadE a'2^\Tutti r8 d'4 e'4. | fis'2 r2 fis'2 |
   d'4 cis'2 b4 a2 ~ | \break
%% 9-12
   a2 r2 a'2 ~ \melisma | a'1. ~ | a'8 a4. r1\melismaEnd | r1. | \break
%% 13-17
   r1 fis2 | \tuplet 3/2 {fis4 fis fis} fis8 gis8 a2. | 
   fis2. r8 b4 cis'4. | \noBreak b4.( a) fis2. | \noBreak
   r1. | \break
%% 18-21
   e1.\melisma | a1. | d'1. | d1\melismaEnd r2 | \break
%% 22-25
   d'2 cis'4 b8( a gis4) r4 | r8 gis'2  fis'8 a'2. ~ |
   a'2. r2.^\fermata | r1. | \break
%% 26-27
   \time 4/1 r\longa  | r\longa | \break
%% 28-
   r\longa | \break
%% 29-32
   \time 3/2
   \Shead b'1^\Solo a'8. r16 gis'4 ~ | gis'2. fis'4 e'4 d'4 ~ |
   d'8 \SheadE b2.^\Tutti b4. b4 ~ | b1 r2 | \break
%% 33-37
   r1. | r1 d2^\fermata | d4 d4. r8 e2. | d8 d4 e8 d4. r8 d2 |
   d8( e4.) gis4 e'2. | \break
%% 38-41
   r1. | r1. | r1. | r1. | \break
%% 42-46
   r2 d'2.^\fermata b4 | r4 gis4. fis2\( cis'4. ~ |
   cis'4.\) r4. d'2.^\fermata | r4 b gis1 |  r2 s1 | \break
%% D.C. bar 1 and bar 2
   \skip 1 r2 |
%% 1-2
   \time 4/1 fis\breve\melisma fis1 fis8\melismaEnd r2.. |
   fis4 gis4. a b4 cis'2.. r2.. r1 | \break
%% Coda-midi
%% 1-4
   \time 3/2
   r4 fis'2 gis'2. | r4 d'4 e'2\( fis'2\) | r8 d'8 fis'2.\( fis'2 |
   fis'2..\) r4  gis4. | \break
%% 5-8
   << \context Voice = TenorSolo {
         \Shead gis'4^\Solo a'4. a'4 a'8 b'2 \SheadE } \\
      \context Voice = TenorTutti { \VoiceColorBlue
         d2\melisma e2 d4. e8\melismaEnd } >> |
   b'2. r4 d'4 e'4\( | fis'1\) d'4 e'4 |
   r8 d'4.\( cis'4 fis'2.\) | \break
%% 9-
}
%%%
%%% Instruments 
tenor = {
     \autoBeamOff
   \partial 2 r2^\fermata |
%% 1-2
   \time 4/1 fis\breve e\breve ~ |
   \pitchedTrill e\longa\startTrillSpan fis | \break
%% 3-4
   e\breve e8\stopTrillSpan r8 fis1.. ~ | \time 3/2 <fis a>1. | \break
%% 5-8
   \pitchedTrill gis1.\startTrillSpan d | a | gis | fis | \break
%% 9-12
   e1 d2\stopTrillSpan ~ | d r4. <d d'>2 <e e'>8 ~ |
   <e e'>8 ~ <e a e'>4. a1 ~ | a1. ~ | \break
%% 13-17
   a2 r1 | r1. | r1 e2 | \noBreak cis1. ~ | \noBreak
   <cis fis>1. ~ | \break
%% 18-21
   fis2 r1 | r1. | r1. | r1. | \break
%% 22-25
   r1. | r1. | r1. | r1. | \break
%% 26-27
   \time 4/1
   fis'\breve <gis' e'>2.. <a' d'>2 r8 a'2 ~ |
   a'2 <d' a'>2. <e' gis'>2. fis'\breve | \break
%% 28-
   <e' cis'>8\( <d' b> <cis' a> <b gis> <a fis> <gis e> <fis d>
   cis\breve\)_\( <cis fis>8 <cis gis> <cis a> <cis b>
   <fis cis'>8 <gis d'> <a e'> <b e'> <cis' fis'>\) ~ | \break
%% 29-32
   \time 3/2
   <cis' fis'>2 r1 | r1. | r1. | r1. | \break
%% 33-37
   r1. | r1. | r1. | r1. | r1. | \break
%% 38-41
   \repeat percent 3 {
   \repeat percent 4 { <d gis>8.^\fermata <cis fis> } } |
   fis2.. e2 r8 | \break
%% 42-46
   r1. | r1. | r1. | r1. | r1. | \break
%% D.C.
%% Coda--Sheet
%% 1-4
   \time 3/2
   fis4\stopTrillSpan <d a>2.^\fermata <e gis>2 |
   %% @@@ Why? From here is warning: barcheck(Only Tener)???
   %% fis2 <d a>2 <e gis>2 ~ | <e gis>2. <d a>2 fis4 ~ |
   %% fis2. <e gis>2. | \break
   fis2 <d a>2 <e gis>2 ~  <e gis>2. <d a>2 fis4 ~ 
   fis2. <e gis>2.  \break
%% 5-8
   \phrasingSlurDashPattern #0.5 #2.0
   %% d1._\( | cis'\)_\( | d\)_\( | cis'\) | \break
   d1._\(  cis'\)_\(  d\)_\(  cis'\)_\(  \break
%% 9-12
%%   cis'1.\) ~ | <d cis'>2. <fis a> | gis1. ~ | gis \bar "|."
   cis'1.\) ~  <d cis'>2. <fis a>  gis1. ~  gis \break
}
%%% end tenor sheet.
%%%
tenorM = {
     \autoBeamOff
   \partial 2 r2^\fermata |
%% 1-2
   \time 4/1 fis\breve e\breve ~ |
   \pitchedTrill e\longa\startTrillSpan fis | \break
%% 3-
   e\breve e8\stopTrillSpan r8 fis1.. ~ | \time 3/2 <fis a>1. | \break
%% 5-8
   \pitchedTrill gis1.\startTrillSpan d | a | gis | fis | \break
%% 9-12
   e1 d2\stopTrillSpan ~ | d r4. <d d'>2 <e e'>8 ~ |
   <e e'>8 ~ <e a e'>4. a1 ~ | a1. | \break
%% 13-17
   a2 r1 | r1. | r1 e2 | \noBreak cis1. ~ | \noBreak
   <cis fis>1. | \break
%% 18-21
   fis2 r1 | r1. | r1. | r1. | \break
%% 22-25
   r1. | r1. | r1. | r1. | \break
%% 26-27
   \time 4/1
   fis'\breve <gis' e'>2.. <a' d'>2 r8 a'2 ~ |
   a'2 <d' a'>2. <e' gis'>2. fis'\breve | \break
%% 28-
   <e' cis'>8\( <d' b> <cis' a> <b gis> <a fis> <gis e> <fis d>
   cis\breve\)_\( <cis fis>8 <cis gis> <cis a> <cis b>
   <fis cis'>8 <gis d'> <a e'> <b e'> <cis' fis'>\) ~ | \break
%% 29-32
   \time 3/2
   <cis' fis'>2 r1 | r1. | r1. | r1. | \break
%% 33-37
   r1. | r1. | r1. | r1. | r1. | \break
%% 38-41
   \repeat percent 3 {
   \repeat percent 4 { <d gis>8.^\fermata <cis fis> } } |
   fis2.. e2 r8 | \break
%% 42-46
   r1. | r1. | r1. | r1. | r1. | \break
%% D.C. (Re-midi bar 1 and bar 2)
%% Re;
   \skip 1 r2 |
%% Re; 1-2
   \time 4/1 fis\breve e\breve ~ |
   \pitchedTrill e\longa\startTrillSpan fis | \break
%% Coda--midi
%% 1-4
   \time 3/2
   fis4\stopTrillSpan <d a>2.^\fermata <e gis>2 |
   fis2 <d a>2 <e gis>2 ~ | <e gis>2. <d a>2 fis4 ~ |
   fis2. <e gis>2. | \break
%% 5-8
   d1._\( | cis'\)_\( | d\)_\( | cis'\)_\( | \break
%% 9-12
   cis'1.\) ~ | <d cis'>2. <fis a> | gis1. ~ | gis \bar "|." \break
}
%%% end tenor-midi
%%%%%%%%%%%%%%%% omit!! %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%% baritone part %%%%%%%%%%%%%%%%%%%%%%%
%% baritone = {
%%      \autoBeamOff
%%    \partial 2 r2^\fermata |
%% 1-
%%    \time 4/1
%%
%% }
%%%  end baritone sheet
%%%
%% baritoneL = \lyricmode {
%%     \override Lyrics.LyricText.color = #blue
%%     \override Lyrics.LyricHyphen.color = #blue
%%     \override Lyrics.LyricExtender.color = #blue
%%     \override Score.LyricText.font-shape = #'italic
%%     \teeny
%%
%% }
%%
%% baritoneM = {
%%      \autoBeamOff
%%    \partial 2 r2^\fermata |
%% 1-
%%    \time 4/1
%%
%% }
%%% end baritone midi
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%%%%%% bass; part %%%%%%%%%%%%%%%%
bassVoice = { \hide Staff.BarLine
   \autoBeamOff
   \partial 2 r2^\fermata |
%% 1-
   \time 4/1 cis\breve^\Tutti \melisma cis1 cis8\melismaEnd %%
             r4 \Shead cis4^\Solo d4. |
   e4. fis4 gis2.. \SheadE r2 r\breve | \break
%% 3-4
   r\breve r2 e4.^\Tutti e2 e8 fis2\( |
   \time 3/2 fis2 gis2.\) r4 |\break
%% 5-8
   b4 b8 \Shead cis'4^\Solo d'4. d'8 d' e'4 ~ |
   e'8 r8 \SheadE d'2^\Tutti r8 gis4 a4. | b2 r2 b2 |
   gis4 fis2 e4 d2 ~ | \break
%% 9-12
   d2 r2 d'2 ~ \melisma | d'1. ~ | d'8 d4. r1\melismaEnd | r1. | \break
%% 13-17
   r2. cis2. | cis8 cis4 cis4. d4 e2 | b,2. r8 e4 fis4. | \noBreak
   \tuplet 3/2 {e4( fis gis)} a4( b cis'2) | \noBreak
   r1. | \break
%% 18-21
   a,1.\melisma | d1. | a,1. | gis1\melismaEnd r2 | \break
%% 22-25
   gis2 fis4 e8( d cis4) r4 | cis'4. r8 b8 a d'2. ~ |
   d'2. r2.^\fermata | r1. | \break
%% 26-27
   \time 4/1 r\longa  | r\longa | \break
%% 28-
   r\longa | \break
%% 29-32
   \time 3/2
   \Shead e'1^\Solo d'8. r16 cis'4 ~ | cis'2. b4 a4 gis4 ~ |
   gis8 \SheadE e2.^\Tutti e4. e4 ~ | e1 r2 | \break
%% 33-37
   r1. | r1 b,2^\fermata | b,4 b,4. r8 cis2. |
   b,8 b,4 cis8 b,4. r8 b,2 | b,8( cis4.) e4 cis'2. | \break
%% 38-41
   r1. | r1. | r1. | r1. | \break
%% 42-46
   gis2.\fermata r8 e4 cis4. | b,2\( fis2.\) r4 |
   r2. gis2.^\fermata | r4 e4 cis1 | r2 s1 \bar "||" \break
%% D.C.
%% Coda-sheet
%% 1-4
   \time 3/2
   r4 b2 cis'2. | r4 gis4 a2\( b2\) | r8 gis8 b2.\( b2 |
   b2..\) r4  cis4. | \break
%% 5-8
   << \context Voice = BassSolo {
         \Shead cis'4^\Solo d'4. d'4 d'8 e'2 \SheadE } \\
      \context Voice = BassTutti { \VoiceColorBlue
         b,2\melisma cis2 b,4. cis8\melismaEnd } >> |
   e'2. r4 gis4 a4\( | b1\) gis4 a4 |
   r8 gis4.\( fis4 b2.\) \undo \hide Staff.BarLine \bar "|" \break
%%
}
bassVoiceL = \lyricmode {
    \override Lyrics.LyricText.color = #blue
    \override Lyrics.LyricHyphen.color = #blue
    \override Lyrics.LyricExtender.color = #blue
    \override Score.LyricText.font-shape = #'italic
    \teeny
m __
De -- scend -- ants "of the" Earth!
"You are" never a trav -- el -- ler!
"It is" the de -- scend -- ant "of the" Earth life,
"in the" uni -- verse. "It is" that sur -- vi -- vor!
w __

"It is the" de -- scend -- ant "of the" universe
where "it was" "in the" solar system!
%% Since we were destroyed, in this universe until now,
w __
What hap -- pened? Tell it to us!
Did "it all" reveal root of this? Tell "it to" us!

We are life forms that have al -- ready been erased from space!
%% But since life was given by the universe,
%% We have the right!
What is this uni -- verse?
What is we?

You guys are nev -- er a trav -- el -- ler!
"It is the" %% descendant of the Earth
life, "in the" uni -- verse
"It is" that sur -- vi -- vor!
}
BassSoloL = \lyricmode {
\override Lyrics.LyricText.color = #red
    \override Lyrics.LyricHyphen.color = #red
    \override Lyrics.LyricExtender.color = #red
    \override Score.LyricText.font-shape = #'italic
    \teeny
De -- scend -- ants "of the" Earth
}
BassTuttiL = \lyricmode {
\override Lyrics.LyricText.color = #blue
    \override Lyrics.LyricHyphen.color = #blue
    \override Lyrics.LyricExtender.color = #blue
    \override Score.LyricText.font-shape = #'italic
    \teeny
w __
}

bassVoiceM = {
    \autoBeamOff
   \partial 2 r2^\fermata |
%% 1-
   \time 4/1 cis\breve\melisma cis1 cis8\melismaEnd r4 cis4 d4. |
   e4. fis4 gis2.. r2 r\breve | \break
%% 3-
   r\breve r2 e4. e2 e8 fis2\( | \time 3/2 fis2 gis2.\) r4 | \break
%% 5-8
   b4 b8 \Shead cis'4^\Solo d'4. d'8 d' e'4 ~ |
   e'8 r8 \SheadE d'2^\Tutti r8 gis4 a4. | b2 r2 b2 |
   gis4 fis2 e4 d2 ~ | \break
%% 9-12
   d2 r2 d'2 ~ \melisma | d'1. ~ | d'8 d4. r1\melismaEnd | r1. | \break
%% 13-17
   r2. cis2. | cis8 cis4 cis4. d4 e2 | b,2. r8 e4 fis4. | \noBreak
   \tuplet 3/2 {e4( fis gis)} a4( b cis'2) | \noBreak
   r1. | \break
%% 18-21
   a,1.\melisma | d1. | a,1. | gis1\melismaEnd r2 | \break
%% 22-25
   gis2 fis4 e8( d cis4) r4 | cis'4. r8 b8 a d'2. ~ |
   d'2. r2.^\fermata | r1. | \break
%% 26-27
   \time 4/1 r\longa  | r\longa | \break
%% 28-
   r\longa | \break
%% 29-32
   \time 3/2
   \Shead e'1^\Solo d'8. r16 cis'4 ~ | cis'2. b4 a4 gis4 ~ |
   gis8 \SheadE e2.^\Tutti e4. e4 ~ | e1 r2 | \break
%% 33-37
   r1. | r1 b,2^\fermata | b,4 b,4. r8 cis2. |
   b,8 b,4 cis8 b,4. r8 b,2 | b,8( cis4.) e4 cis'2. | \break
%% 38-41
   r1. | r1. | r1. | r1. | \break
%% 42-46
   gis2.\fermata r8 e4 cis4. | b,2\( fis2.\) r4 |
   r2. gis2.^\fermata | r4 e4 cis1 | r2 s1 \bar "||" \break
%% D.C. bar 1 and bar 2
   \skip 1 r2 |
%% 1-2
   \time 4/1 cis\breve\melisma cis1 cis8\melismaEnd r4 cis4 d4. |
   e4. fis4 gis2.. r2 r\breve | \break
%% Coda-midi
%% 1-
   \time 3/2
   r4 b2 cis'2. | r4 gis4 a2\( b2\) | r8 gis8 b2.\( b2 |
   b2..\) r4  cis4. | \break
%% 5-8
   << \context Voice = TenorSolo {
         \Shead cis'4^\Solo d'4. d'4 d'8 e'2 \SheadE } \\
      \context Voice = TenorTutti { \VoiceColorBlue
         b,2\melisma cis2 b,4. cis8\melismaEnd } >> |
   e'2. r4 gis4 a4\( | b1\) gis4 a4 |
   r8 gis4.\( fis4 b2.\) | \break
%% 9-
}
%%%
%%% Instruments 
bass = {
   \autoBeamOff
   \partial 2 r2^\fermata |
%% 1-2
   \time 4/1 cis\breve b,\breve ~ |
   \pitchedTrill b,\longa\startTrillSpan cis | \break
%% 3-4
   b,\breve b,8\stopTrillSpan r8 cis1.. ~ | \time 3/2 <cis e>1. | \break
%% 5-8
   \pitchedTrill cis1.\startTrillSpan gis, | d | cis | b, | \break
%% 9-12
   a,1 gis,2\stopTrillSpan ~ | gis, r4. <gis, gis>2 <a, a>8 ~ |
   <a, a >8 <a, d a>4. d1 ~ | d1. ~ | \break
%% 13-17
   d2 r1 | r1. | r2 e,1 |
   fis,8.-._( gis,-. a,-. b,-. cis-. d-. e-. fis) ~ |
   <fis cis>4 <gis d>4. <a e>4. <b fis>2 ~ | \break
%% 18-21
   fis2 r1 | r1. | r1. | r1. | \break
%% 22-25
   r1. | r1. | r1. | r1. | \break
%% 26-27
   \time 4/1
   b\breve <cis' a>2.. <d' gis>2 r8 d'2 ~ |
   d'2 <gis d'>2. <a cis'> b\breve | \break
%% 28-
   <a, cis>8_\( <b, d> <cis e> <d fis> <e gis> <fis a> <gis b>\)
   a\breve\( <d' gis>8 <cis' fis> <b e> <a d> <gis cis>
   <fis gis,> <e gis,> <d gis,> <cis gis,>\) ~ | \break
%% 29-32
   <cis gis,>2 r1 | r1. | r1. | r1. | \break
%% 33-37
   r1. | r1. | r1. | r1. | r1. | \break
%% 38-41
   \repeat percent 3 {
   \repeat percent 4 { <fis, b,>8.^\fermata <gis, cis> } } |
   b,2.. a,2 r8 | \break
%% 42-46
   r1. | r1. | r1. | r1. | r1. | \break
%% D.C.
%% Coda-sheet
%% 1-4
   \time 3/2
   cis4\stopTrillSpan r2^\markup { \hspace #6 \fermata }
   \repeat percent 3 { <a, cis>16 r16 <b, gis,>16 r16 } |
   \repeat percent 12 { r16 <gis, b,>16 r16 <a, cis>16 } |
   gis,16 a,8 b,8. cis4 d4. e2 | \break
%% 5-8
   \phrasingSlurDashPattern #0.5 #2.0
   fis1._\( | gis,\)_\( | fis\)_\( | gis,\)_\( | \break
%% 9-12
   fis1.\) ~ | <gis, fis>2. <b, d> | cis1. ~ | cis \bar"|." \break
}
%%% end bass-sheet
%%%
bassM = {
   \autoBeamOff
   \partial 2 r2^\fermata |
%% 1-
   \time 4/1 cis\breve b,\breve ~ |
   \pitchedTrill b,\longa\startTrillSpan cis | \break
%% 3-4
   b,\breve b,8\stopTrillSpan r8 cis1.. ~ | \time 3/2 <cis e>1. | \break
%% 5-8
   \pitchedTrill cis1.\startTrillSpan gis, | d | cis | b, | \break
%% 9-12
   a,1 gis,2\stopTrillSpan ~ | gis, r4. <gis, gis>2 <a, a>8 ~ |
   <a, a>8 ~ <a, d a>4. d1 ~ | d1. ~ | \break
%% 13-17
   d2 r1 | r1. | r2 e,1 |
   fis,8.-._( gis,-. a,-. b,-. cis-. d-. e-. fis) ~ |
   <fis cis>4 <gis d>4. <a e>4. <b fis>2 ~ | \break
%% 18-21
   fis2 r1 | r1. | r1. | r1. | \break
%% 22-25
   r1. | r1. | r1. | r1. | \break
%% 26-27
   \time 4/1
   b\breve <cis' a>2.. <d' gis>2 r8 d'2 ~ |
   d'2 <gis d'>2. <a cis'> b\breve | \break
%% 28-
   <a, cis>8_\( <b, d> <cis e> <d fis> <e gis> <fis a> <gis b>\)
   a\breve\( <d' gis>8 <cis' fis> <b e> <a d> <gis cis>
   <fis gis,> <e gis,> <d gis,> <cis gis,>\) ~ | \break
%% 29-
   <cis gis,>2 r1 | r1. | r1. | r1. | \break
%% 33-37
   r1. | r1. | r1. | r1. | r1. | \break
%% 38-41
   \repeat percent 3 {
   \repeat percent 4 { <fis, b,>8.^\fermata <gis, cis> } }
   b,2.. a,2 r8 | \break
%% 42-46
   r1. | r1. | r1. | r1. | r1. | \break
%% D.C. (Re-midi bar 1 and bar 2)
%% Re;
   \skip 1 r2 |
%% Re; 1-2
   \time 4/1 cis\breve b,\breve ~ |
   \pitchedTrill b,\longa\startTrillSpan cis | \break
%% Coda-midi
%% 1-4
   \time 3/2
   cis4\stopTrillSpan r2^\markup { \hspace #6 \fermata }
   \repeat percent 3 { <a, cis>16 r16 <b, gis,>16 r16 } |
   \repeat percent 12 { r16 <gis, b,>16 r16 <a, cis>16 } |
   gis,16 a,8 b,8. cis4 d4. e2 | \break
%% 5-8
   fis1._\( | gis,\)_\( | fis\)_\( | gis,\)\( | \break
%% 9-12
   fis1.\) ~ | <gis, fis>2. <b, d> | cis1. ~ | cis \bar"|." \break
}
%%% end bass-midi
%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%% End All %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
