﻿%% 2:35 Saturday, December 27, 2025
%% Yukio Yoshida.

\version "2.24.0"
\include "ave-maria-cv.ly"
#(set-default-paper-size "letter")
#(set-global-staff-size 18)
\paper {
        %%ragged-last-bottom = ##f
}

\book{
%%%%%%%%%%%%%%%%%%%%%%%%%%%
\bookpart{ %% #1
\markup{ \vspace #4 }
%% make sheet-my-epstitle
#(let* ((port (open-output-file "sheet-my-epstitle.eps")))
  (display "%!PS-Adobe-3.0 EPSF-3.0
%%BoundingBox: 10 10 900 230
%%Creator: Y.Yoshida
%%Title: LilyPond Sample
%%CreationData 8/14/2017 12:07
%%EndComments
/Times-Italic findfont 120 scalefont setfont 20 40 moveto 1 0 0 setrgbcolor
(Ave Maria) false charpath 3 setlinewidth stroke" port)

  (close port))
%Trailer
%% end make sheet-my-epstitle --------
\markup{ \hspace #34 \epsfile #X #80 #"sheet-my-epstitle.eps" }
\markup { \vspace #3 }
\markup{ \override #'(line-width . 80)
\hspace #12 \raise #50 {
   \column { \bold \italic
      \column {
\normal-text "   Prayer words"
" "
"Ave Maria, gratia plena,"
"Dominus tecum,"
"    benedicta tu in mulieribus,"
"    et benedictus fructus ventris tui Jesus."
" "
\teeny \normal-text "          (Posterity, additional statements by the Franciscan)"
"Sancta Maria mater Dei,"
"    ora pro nobis peccatoribus, nunc,"
"    et in hora mortis nostrae."
" "
"Amen."
" "
            } }
}
\hspace #16 \epsfile #X #40 #"Raphael_-_Madonna_dell_Granduca.eps" 
}
\markup { \hspace #90 \teeny \normal-text "[Grand St.Mary's]"}
\markup { \hspace #82 \teeny \normal-text "Painter; Raffaello Sanzio(1483--1520)"}
\markup { \vspace #4 }
\markup{ \hspace #10
\epsfile #X #20 #"Raphael_-_Madonna_dell_Granduca.eps"
\hspace #-20 \epsfile #Y #10 #"Raphael_-_Madonna_dell_Granduca.eps"
      }
}%%End \bookpart { #1
\pageBreak
%%%%%%%%%%%%%%%%%%%%%%%%%%%
\bookpart{ %% #2 
\header {
 dedication = " "
 title = "Ave Maria"
 subtitle = \markup{ \center-column { \bold "2018"
                          \vspace #-.3 \italic "a major; cis d e fis gis a b" } }
 %% subsubtitle = #(string-append "LilyPond version " (lilypond-version))
 subsubtitle = \markup{ \vspace #1 \tiny \center-column {
                   "soprano; C clef on 1st line,       alto; C clef on 3rd line."
                   "       bass; F clef on 4th line,    tenor; C clef on 4th line."}}
 composer = \markup{ \line {\italic "Yukio Yoshida"}}
 arranger = "12/7/2017"
 poet = " Like to pray (Voice is Strong!)"
 opus = "Op.98 Ave Maria; #13"
 meter = \markup { \hspace #12 \italic \column { \bold \line { Pre-Words }
         \line { Amen Ave ; bass }
         \line { Hail Queen of heaven ; Soprano }
         \line { Hail Empress of the angels ; Alto }
         \line { Ave Regina caelorum ; Tenor } } }
 copyright = "public Domain"
}

%%%%%%%%%% sheet and midi music code part %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% get sheet music ---------------------------------------------------
\score {
  <<
%%  \context ChoirStaff = "FourPartStaffaddchorus" <<
  \context StaffGroup << 
  \context Voice = "soprano" { \clef soprano \key a\major \time 3/2
                    \set Staff.fontSize = #-4
                    \override Staff.StaffSymbol.staff-space = #(magstep -4)
                    \override Staff.StaffSymbol.thickness = #(magstep -4)
                      \set Staff.instrumentName = "soprano" \soprano }
  \context Voice = "sopranoVocal" { \clef soprano \key a\major \time 3/2
                     \set Staff.instrumentName = "Voice; sop "
                                          \VoiceColorBlue { \sopranoVoice } }
  \new Lyrics = "mainSL" \lyricsto "sopranoVocal" { \sopranoVoiceL }

  \context Voice = "alto" { \clef alto \key a\major \time 3/2
                   \set Staff.fontSize = #-4
                   \override Staff.StaffSymbol.staff-space = #(magstep -4)
                   \override Staff.StaffSymbol.thickness = #(magstep -4)
                   \set Staff.instrumentName = "alto   " \alto }
  \context Voice = "altoVocal" { \clef alto \key a\major \time 3/2
                   \set Staff.instrumentName = "Voice; alt "
                                             \VoiceColorBlue { \altoVoice } }
  \new Lyrics = "mainSL" \lyricsto "altoVocal" { \altoVoiceL }

  \context Voice = "tenor" { \clef tenor \key a\major \time 3/2
                   \set Staff.fontSize = #-4
                   \override Staff.StaffSymbol.staff-space = #(magstep -4)
                   \override Staff.StaffSymbol.thickness = #(magstep -4)
                   \set Staff.instrumentName = "tenor  " \tenor }
  \context Voice = "tenorVocal" { \clef tenor \key a\major \time 3/2
                   \set Staff.instrumentName = "Voice; ten "
                                          \VoiceColorBlue { \tenorVoice  } }
  \new Lyrics = "mainSL" \lyricsto "tenorVocal" { \tenorVoiceL }

%%%%%%%%%%%%%%%%%%%% OMIT %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%% baritone part %%%%%%%%%%%%%%%%%%%%%%%
%%  \context Voice = "baritone" { \clef baritone \key a\major \time 3/2
%%                    \set Staff.instrumentName = \markup { \column {
%%                    \with-color #blue "baritone  "
%%                                  \tiny \with-color #blue "Solo; singer" } }
%%                                               \BaritoneSol { \baritone } }
%%  \new Lyrics = "mainTL" \lyricsto "baritone" { \baritoneL }
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  \context Voice = "bass" { \clef bass \key a\major \time 3/2
                   \set Staff.fontSize = #-4
                   \override Staff.StaffSymbol.staff-space = #(magstep -4)
                   \override Staff.StaffSymbol.thickness = #(magstep -4)
                    \set Staff.instrumentName = "bass   " \bass }
  \context Voice = "bassVocal" { \clef bass \key a\major \time 3/2
                   \set Staff.instrumentName = "Voice; bas "
                                            \VoiceColorBlue { \bassVoice } }
  \new Lyrics = "mainBL" \lyricsto "bassVocal" { \bassVoiceL }
  \new Lyrics = "mainBL" \lyricsto "bassU" { \bassU }
  \new Lyrics = "mainBL" \lyricsto "bassL" { \bassL }

  >>
            >>

  \layout {
     \context { \Staff \RemoveEmptyStaves
                %% \override VerticalAxisGroup.remove-first = ##t
                      }
           }
}

%% get midi music --------------------------------------------------
\score {
  %% \unfoldRepeats \articulate 
  <<
  \context Staff { \clef soprano \key a\major \time 3/2 \tempo 4 = 46
%%                        \set Staff.midiInstrument = "pad 4 (choir)"
                        \set Staff.midiInstrument = "string ensemble 1"
                                  \unfoldRepeats       \sopranoM }
  \context Staff { \clef soprano \key a\major \time 3/2 \tempo 4 = 46
                        \set Staff.midiInstrument = "pad 4 (choir)"
                             \unfoldRepeats       \sopranoVoiceM }

  \context Staff { \clef alto \key a\major \time 3/2 \tempo 4 = 46
%%                        \set Staff.midiInstrument = "pad 4 (choir)"
                        \set Staff.midiInstrument = "string ensemble 1"
                               \unfoldRepeats          \altoM }
  \context Staff { \clef alto \key a\major \time 3/2 \tempo 4 = 46
                        \set Staff.midiInstrument = "pad 4 (choir)"
                          \unfoldRepeats          \altoVoiceM }

  \context Staff { \clef tenor \key a\major \time 3/2 \tempo 4 = 46
%%                        \set Staff.midiInstrument = "pad 4 (choir)"
                        \set Staff.midiInstrument = "string ensemble 1"
                                   \unfoldRepeats       \tenor }
  \context Staff { \clef tenor \key a\major \time 3/2 \tempo 4 = 46
                      \set Staff.midiInstrument = "pad 4 (choir)"
                             \unfoldRepeats       \tenorVoiceM }

%%%%%%%%%%%%%%%%%%%% OMIT %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%% baritone part %%%%%%%%%%%%%%%%%%%%%%%
%%  \context Staff { \clef baritone \key a\major \time 3/2 \tempo 4 = 46
%%                         \set Staff.midiInstrument = "pad 4 (choir)"
%%                                  \unfoldRepeats       \baritoneM }
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

   \context Staff { \clef bass \key a\major \time 3/2 \tempo 4 = 46
%%                        \set Staff.midiInstrument = "pad 4 (choir)"
                        \set Staff.midiInstrument = "string ensemble 1"
                                \unfoldRepeats          \bassM }
   \context Staff { \clef bass \key a\major \time 3/2 \tempo 4 = 46
                      \set Staff.midiInstrument = "pad 4 (choir)"
                           \unfoldRepeats          \bassVoiceM }
   >>

   \midi { tempoWholesPerMinute = #(ly:make-moment 46 4) }
}
%%%%%%%%%
\markup { " " }
%%%%%%%%%
%% \markup { " " }
%%\pageBreak %% since, Even-Page.
%% \markup { \null }
%%%%%%
%%\pageBreak
\markup { \vspace #1 }
\markup { \column { \line {
About location \hspace #3 \musicglyph #"noteheads.uM2"(longa)
\hspace #2 and \hspace #3 \musicglyph #"noteheads.sM1"(breve) }
\line { \hspace #4 \italic
"Please, Breath of longa and breve do in the members alternating
(But, like Don't stand out). " } } }
\markup { \vspace #.5 }
\markup { " " }
\markup { \line {
At location \musicglyph #"scripts.ufermata", \hspace #1
\italic " Always, please look at the conductor(or baton). " } }
\markup { " " }
%%%%%%%%
\markup { \vspace #10 }
\markup { \column { \line { \hspace #16 \bold "Luke 1"\teeny "(Bilingual Bible-English-)"
              \hspace #38 \bold "Ave Maria"\teeny "(Latin)" }
          \line { \hspace #16 \small --Source of Ave Maria--} } }
\markup {%%column * 2
\fill-line {
 \column { \bold
 \line { \italic \small
   \column {
\teeny "1-28)"
" The angel went to her and said,"
"\"Greetings, you who are highly favored!"
" The Lord with you.\""
\teeny "1-42)"
" In a loud voice she exclaimed:"
"\"Blessed are you among women, and"
" blessed is the child you will bear!.....\""
" "
            }
\hspace #20
   \column { \bold \italic
      \column {
" "
" "
"Ave Maria, gratia plena,"
"Dominus tecum,"
"    benedicta tu in mulieribus,"
"    et benedictus fructus ventris tui Jesus."
" "
\teeny \normal-text "          (Posterity, additional statements by the Franciscan)"
"Sancta Maria mater Dei,"
"    ora pro nobis peccatoribus, nunc,"
"    et in hora mortis nostrae."
" "
"Amen."
            } }
        }
}}}
\markup { \vspace #2 }

\pageBreak
\markup { " " }
\markup { \vspace #12 }
\markup { \line \smallCaps { Luke \tiny {(THE HOLY BIBLE, NEW INTERNAONAL VERSION)
}} }
\markup { \hspace #20 \column {
          \line \smallCaps {Luke 1 \teeny {--excerpted this paragraph--}}
\hspace #0
\line \bold\italic { \hspace #6 The Birth of Jesus Foretold }
\line {....................}
\override #'(line-width . 60)
\wordwrap \italic {
\concat{ " "\super 28 }The angel went to her and said, ``Greetings, you who are
highly favored! The Lord is with you.''}
\hspace #0
\line \bold\italic { \hspace #6 Mary Visits Elizabeth }
\line {....................}
\override #'(line-width . 60)
\wordwrap \italic {
\concat{ " "\super 42 }In a loud voice she exclaimed: ``Blessed are you among woman.
and blessed is the child you will bear!''}
\hspace #0
\line \bold\italic { \hspace #6 Mary's Song }
\column \italic {
\line { \concat{ " "\super 46 }And Mary said: }
"`` My soul glorifies the Lord"
\line { \concat{ " "\super 47 }"  "and my spirit rejoices in God my savior,}
\line { \concat{ " "\super 48 }for he has been mindful}
"       of the humble state of his servant."
"     From now on all generations will call me blessed,"
\line { \concat{ " "\super 49 }"    "for the Mighty One has done great things for}
\line{"                       "me \raise #.5 \draw-line #'(2 . 0)}
"         holy is his name."
\line { \concat{ " "\super 50 }His mercy extends to those who fear him,}
"         from generation to generation."
\line { \concat{ " "\super 51 }He has performed mighty deeds with his arm:}
"         he has scattered those who are proud in thier inmost thoughts."
\line { \concat{ " "\super 52 }He has brought down rulers from their thrones}
"         but has liftd up the humble."
\line { \concat{ " "\super 53 }He has filled the hungry with good things}
"         but has sent the rich away empty."
\line { \concat{ " "\super 54 }He has helped his servant Israel,}
"         remembering to be merciful"
\line { \concat{ " "\super 55 }to Abraham and his descendants forever,}
"         even as he said to our fathers.''"
\line { \concat{ " "\super 56 }"   "Mary stayed with Elizabeth for about three
months and then returned home.}
}
}}
\markup{ " " }
\pageBreak
%% eps-part -------------------------------------------------------------------
%% C:\Program Files (x86)\LilyPond\usr\share\ghostscript\8.70\Resource\Init\
%% Fontmap.GS // Not!! [Windows--ghostscript]
#(let* ((port (open-output-file "Source-code.eps")))
  (display "%!PS-Adobe-3.0 EPSF-3.0
%%BoundingBox: 60 227 525 636
%%HiResBoundingBox: 60.20 227.30 524.50 635.60
%%Creator: GPL Ghostscript 922 (eps2write)
%%LanguageLevel: 2
%%CreationDate: D:20180608144500+09'00'
%%Pages: 1
%%EndComments
/Times-Italic findfont 200 scalefont setfont 120 500 moveto 1 0 0 setrgbcolor
(ALL) false charpath 4 setlinewidth stroke

/Times-Italic findfont 120 scalefont setfont 60 320 moveto 0 0 0 setrgbcolor
(SOURCE) false charpath 3 setlinewidth stroke

/Times-Italic findfont 120 scalefont setfont 100 230 moveto 0 0 0 setrgbcolor
(CODE) false charpath 1 setlinewidth stroke"
port)

  (close port))
%Trailer
%% end -----eps part-------------------------------------------------------------------
%%%% Needn't Surce code's Title-String for texi-document.
\markup { \vspace #10 }
\markup { \hspace #12 \epsfile #X #100 #"Source-code.eps" }
\markup { " " }
\markup { \vspace #1 }
\markup { \fill-line { \center-column {
\line { As all;\hspace #2 See! (HTML) @menu }
"https://www.sheet-poem.com/poem/html/2018/2.24.0/ave-maria/ave-maria-2018.html" } } }
\pageBreak
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
}%% End \bookpart { #2
%%%%%%%%%%%%%%%%%%%%%%%%%%%
}%% close \book { ALL END
%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% ----- To here, Finish all. -----------------%%
