﻿%% 5:08 AM Saturday, August 31, 2024
%% Yukio Yoshida
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% !! LilyPond "\book format" use. !! %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\version "2.24.0"
#(set-default-paper-size "letter")
#(set-global-staff-size 18)
\include "departure-cv.ly"
\book{
\bookpart{ %% #I Caver's title
\markup{ \vspace #-.5 }
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
#(let* ((port (open-output-file "sheet-title-line.eps")))
  (display "%!PS-Adobe-3.0 EPSF-3.0
%!PS-Adobe-3.0 EPSF-3.0
%%Invocation: gs -sDEVICE=eps2write -sOutputFile=? -dNOPAUSE ? ? ?
%%BoundingBox: 15 10 585 810
%%HiResBoundingBox: 15.00 10.00 585.00 810.00
%%Creator: GPL Ghostscript 9550 (eps2write)
%%LanguageLevel: 2
%%CreationDate: D:20240501224226+09'00'
%%Pages: 1
%%EndComments
newpath
25 20 moveto 25 800 lineto 25 800 moveto 575 800 lineto
575 800 moveto 575 20 lineto 575 20 moveto 25 20 lineto
.22 0 0 setrgbcolor 20 setlinewidth stroke
%% in-line
newpath
50 50 moveto 50 760 lineto 50 760 moveto 546 760 lineto
546 760 moveto 546 50 lineto 546 50 moveto 50 50 lineto
0 0 0 setrgbcolor 1 setlinecap 3 setlinewidth stroke
%% Title-Word
/Times-Italic findfont 14 scalefont setfont 80 740 moveto
0 0 0 setrgbcolor
(Soprano;  Instrument  and Voice                          --- C \\clef on 1st line) false charpath 0 setlinewidth stroke
/Times-Italic findfont 14 scalefont setfont 80 725 moveto
0 0 0 setrgbcolor
(MezzoSoprano;  Instrument  and Voice               --- C \\clef on 2nd line) false charpath 0 setlinewidth stroke
/Times-Italic findfont 14 scalefont setfont 80 710 moveto
0 0 0 setrgbcolor
(Alto;  Instrument  and Voice                                --- C \\clef on 3rd line) false charpath 0 setlinewidth stroke
/Times-Italic findfont 14 scalefont setfont 80 695 moveto
0 0 0 setrgbcolor
(Tenor;  Instrument  and Voice                             --- C \\clef on 4th line) false charpath 0 setlinewidth stroke
/Times-Italic findfont 14 scalefont setfont 80 680 moveto
0 0 0 setrgbcolor
(Baritone;  Instrument  and Voice                         --- C \\clef on 5th line) false charpath 0 setlinewidth stroke
/Times-Italic findfont 14 scalefont setfont 80 665 moveto
0 0 0 setrgbcolor
(bas;  Instrument  and Voice                                 --- F \\clef on 4th line) false charpath 0 setlinewidth stroke
/Times-Italic findfont 120 scalefont setfont 110 560 moveto
1 0 0 setrgbcolor
(SHEET) false charpath 3 setlinewidth stroke
/Times-Italic findfont 16 scalefont setfont 180 540 moveto
0 0 0 setrgbcolor
(Typesetting output with LilyPond) false charpath 0 setlinewidth stroke
%%%%
/Times-Italic findfont 110 scalefont setfont 120 400 moveto
0 1 0 setrgbcolor
(POEM) false charpath 3 setlinewidth stroke
%%%%
/Times-Italic findfont 24 scalefont setfont 180 440 moveto
0 0 0 setrgbcolor
(         Departure) false charpath 2 setlinewidth stroke
/Times-Italic findfont 20 scalefont setfont 210 340 moveto
0 0 0 setrgbcolor
(MUSICAL   INSTRUMENT) false charpath 1 setlinewidth stroke
/Times-Italic findfont 20 scalefont setfont 280 320 moveto
0 0 0 setrgbcolor
(and) false charpath 1 setlinewidth stroke
/Times-Italic findfont 120 scalefont setfont 61 234 moveto
0 0 0 setrgbcolor
(MIXED) false charpath 3 setlinewidth stroke
/Times-Italic findfont 120 scalefont setfont 58 150 moveto
0 0 0 setrgbcolor
(CHORUS) false charpath 3 setlinewidth stroke
/Times-Italic findfont 120 scalefont setfont 58 62 moveto
0 0 0 setrgbcolor
(GROUP) false charpath 3 setlinewidth stroke" port )

 (close port))
%Trailer
%% end make sheet-title-line.eps --------
\markup { \center-column {
\epsfile #X #124 #"sheet-title-line.eps"
%% \epsfile #X #140 #"sheet-title-line.eps"
\vspace #-3  %% Under of Title letters
\line { \bold \italic \tiny
"The dynamic of performance is freedom(the conductor's) discretion." } }}
}%% end bookpart I %%%%%%%%%%%%%%%%%%%%%%%%%%%
\pageBreak
%%%%%% Poem area
\markup { \vspace #8 }
\markup { \hspace #18 \column {
" "
\magnify #1.5 \with-color #red "Departure"
"  "
"  "
"A departure from which there will be no return"
"A departure from which there will be no return"
"   "
"The past is far away"
"Beyond extinction"
"people live on that land"
"depart by death"
"   "
"A departure from which there will be no return"
"A departure from which there will be no return"
"   "
"A departure from which you will never return alive"
"People live in space"
"Humans live in space"
"A departure from which you will never return alive"

"  "
"  "
\line { \hspace #24 \italic "manuscript(5/14/2024), End. " }
\vspace #2
\line { \tiny \italic "Add; as vocal" }
\line { \smallCaps {\with-color #blue "Pronunciation-Symbol" } \bold "ɑ" \tiny \italic "or" \bold "ɔ , ɔː , m , n , ɑ ,  ɑː" }
} } %% end poem area.
%% End cover page out %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% music cord start %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\pageBreak
\bookpart{ %% II
\header {
dedication = \markup { \italic "  " }
title = \markup{ \line { 
            \italic \huge "Departure"\normalsize "(Earth 4)"} }
subtitle = \markup{ \center-column {
            \italic "f major; c d e f g a bes" } }
subsubtitle = \markup{\center-column {
%% \italic \with-color #blue "Baritone; C clef on 5th line(& Solo; singer)."
\italic "soprano; C clef on 1st line,       alto; C clef on 3rd line."
\italic "     bass; F clef on 4th line,     tenor; C clef on 4th line."}}
composer = \markup { \bold "    Op.115; Departure" }
arranger = \markup { \italic "Yukio Yoshida" }
copyright = "public Domain"
meter = \markup { \hspace #18 \column { \line { \tiny \italic \column { %% get; 2-column
\bold { \tiny " Voice Words [ Sop , Alt , Ten , Bas ]" }
\raise #1 \bold "1) "
\raise #2 "A departure from which there will be no return"
\raise #3 "A departure from which there will be no return"
\vspace #.3
\raise #4 "The past is far away"
\raise #5 "Beyond extinction"
\raise #6 "people live on that land"
\raise #7 "depart by death"
\raise #10 "  "
}\hspace #18 \teeny \italic \column {
\vspace #1.12
\raise #1 \bold "2) "
\raise #2 "A departure from which there will be no return"
\raise #3 "A departure from which there will be no return"
\vspace #.3
\raise #4 "A departure from which you will never return alive"
\raise #5 "People live in space"
\raise #6 "Humans live in space"
\raise #7 "A departure from which you will never return alive"
\raise #10 "  "
%% Special my personal writting ; Normally dont' use !! %%%
\raise #11 \with-color #blue "(Pronunciation-Symbol)"
\raise #12.5 \bold \with-color #blue " ɔ , ɔː , m , n , ɑ ,  ɑː "
}}
\vspace #2 } }
poem = "Yukio Toshida"
%% tagline = "    "
}%% End header
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% get sheet music ---------------------------------------------------
\score {
  <<
%%  \context ChoirStaff = "FourPartStaffaddchorus" <<
    \context StaffGroup <<
  \context Voice = "soprano" { \clef soprano \key f\major \time 3/2
         \set Staff.instrumentName = "soprano" \soprano }
  \context Voice = "sopranoVocal" { \clef soprano \key f\major \time 3/2
         %% \set Staff.fontSize = #-3
         %% \override Staff.StaffSymbol.staff-space = #(magstep -4)
         %% \override Staff.StaffSymbol.thickness = #(magstep -4)
         \set Staff.instrumentName = "Voice; sop "
                               \VoiceColorBlue { \sopranoVoice } }
  \new Lyrics = "mainSL" \lyricsto "sopranoVocal" { \sopranoVoiceL }

  \context Voice = "alto" { \clef alto \key f\major \time 3/2
           \set Staff.instrumentName = "alto   " \alto }
  \context Voice = "altoVocal" { \clef alto \key f\major \time 3/2
         %% \set Staff.fontSize = #-3
         %% \override Staff.StaffSymbol.staff-space = #(magstep -4)
         %% \override Staff.StaffSymbol.thickness = #(magstep -4)
         \set Staff.instrumentName = "Voice; alt "
                              \VoiceColorBlue { \altoVoice } }
  \new Lyrics = "mainSL" \lyricsto "altoVocal" { \altoVoiceL }

  \context Voice = "tenor" { \clef tenor \key f\major \time 3/2
           \set Staff.instrumentName = "tenor  " \tenor }
  \context Voice = "tenorVocal" { \clef tenor \key f\major \time 3/2
         %% \set Staff.fontSize = #-3
         %% \override Staff.StaffSymbol.staff-space = #(magstep -4)
         %% \override Staff.StaffSymbol.thickness = #(magstep -4)
         \set Staff.instrumentName = "Voice; tenor "
                             \VoiceColorBlue { \tenorVoice  } }
  \new Lyrics = "mainSL" \lyricsto "tenorVocal" { \tenorVoiceL }
  
%%%%%%%%% omit %%%%%%%%%%%%%%%%%%%%%%%%%%
%%   \context Voice = "baritone" { \clef baritone \key f\major \time 3/2
%%           \set Staff.instrumentName = \markup { \column {
%%           \with-color #blue "baritone  "
%%                         \tiny \with-color #blue "Solo; singer" } }
%%                                      \BaritoneSol { \baritone } }
%%   \new Lyrics = "mainTL" \lyricsto "baritone" { \baritoneL }
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  \context Voice = "bass" { \clef bass \key f\major \time 3/2
          \set Staff.instrumentName = "bass   " \bass }
  \context Voice = "bassVocal" { \clef bass \key f\major \time 3/2
         %% \set Staff.fontSize = #-3
         %% \override Staff.StaffSymbol.staff-space = #(magstep -4)
         %% \override Staff.StaffSymbol.thickness = #(magstep -4)
         \set Staff.instrumentName = "Voice; bass "
                           \VoiceColorBlue { \bassVoice } }
  \new Lyrics = "mainBL" \lyricsto "bassVocal" { \bassVoiceL }
  >>
            >>

  \layout {
     \context { \Staff \RemoveEmptyStaves
                       %% \override VerticalAxisGroup.remove-first = ##t
                      }
           }
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% get midi musi
\score {
  <<
  \context ChoirStaff = "FourPartStaffaddchorus" <<
  \context Voice = "soprano" { \clef soprano \key f\major \time 3/2
         \set Staff.midiInstrument = "pad 4 (choir)"
         \set Staff.instrumentName = "soprano" \unfoldRepeats \sopranoM }
\context Voice = "sopranoVocal" { \clef soprano \key f\major \time 3/2
         \set Staff.midiInstrument = "pad 4 (choir)"
         \set Staff.instrumentName = "Voice; sop "
                               \VoiceColorBlue { \sopranoVoiceM } }
  %% \new Lyrics = "mainSL" \lyricsto "sopranoVocal" { \sopranoVoiceLM }

  \context Voice = "alto" { \clef alto \key f\major \time 3/2
           \set Staff.midiInstrument = "pad 4 (choir)"
           \set Staff.instrumentName = "alto   " \unfoldRepeats \altoM }
  \context Voice = "altoVocal" { \clef alto \key f\major \time 3/2
         \set Staff.midiInstrument = "pad 4 (choir)"
         \set Staff.instrumentName = "Voice; alt "
                              \VoiceColorBlue { \altoVoiceM } }
%%  \new Lyrics = "mainSL" \lyricsto "altoVocal" { \altoVoiceLM }

  \context Voice = "tenor" { \clef tenor \key f\major \time 3/2
           \set Staff.midiInstrument = "pad 4 (choir)"
           \set Staff.instrumentName = "tenor  " \unfoldRepeats \tenorM }
  \context Voice = "tenorVocal" { \clef tenor \key f\major \time 3/2
         \set Staff.midiInstrument = "pad 4 (choir)"
         \set Staff.instrumentName = "Voice; tenor "
                             \VoiceColorBlue { \tenorVoiceM  } }
%%  \new Lyrics = "mainSL" \lyricsto "tenorVocal" { \tenorVoiceLM }

%%%%%%% omit %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%   \context Voice = "baritone" { \clef baritone \key f\major \time 3/2
%%           \set Staff.midiInstrument = "pad 4 (choir)"
%%           \set Staff.instrumentName = \markup { \column {
%%           \with-color #blue "baritone  "
%%                         \tiny \with-color #blue "Solo; singer" } }
%%                                      \BaritoneSol { \baritoneM } }
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

  \context Voice = "bass" { \clef bass \key f\major \time 3/2
          \set Staff.midiInstrument = "pad 4 (choir)"
          \set Staff.instrumentName = "bass   " \unfoldRepeats \bassM }
  \context Voice = "bassVocal" { \clef bass \key f\major \time 3/2
         \set Staff.midiInstrument = "pad 4 (choir)"
         \set Staff.instrumentName = "Voice; bass "
                           \VoiceColorBlue { \bassVoiceM } }
%%  \new Lyrics = "mainBL" \lyricsto "bassVocal" { \bassVoiceLM }
  >>
            >>
  \midi { tempoWholesPerMinute = #(ly:make-moment 46 4) }
}
%%%%%%%%%
%% \markup { " " }
%%\pageBreak %% since, Even-Page.
%% \markup { \null }
%%%%%%
%% \pageBreak
%% \markup { " " }
\markup { \vspace #6 }
\markup { \column { \line { * About location \hspace #3 \musicglyph #"noteheads.uM2"(longa)
\hspace #2 and \hspace #3 \musicglyph #"noteheads.sM1"(breve) }
\line { \hspace #4 \italic
"Please, Breath of longa and breve do in the members alternating(But, like Don't stand out). " } } }
\markup { \vspace #.5 }
\markup { " " }
\markup { \line { * At location \musicglyph #"scripts.ufermata", \hspace #1
\italic " Always, please look at the conductor(or baton). " } }
\markup { \vspace #.5 }
\markup { " " }
\markup { \column { \line {* \with-color #red { Each person is free to speak the words as they wish.}}
                                  \with-color #blue "        People live in space. , Humans live in space. , ..... return alive, ....etc." }}
\markup { " " }
\markup { * \with-color #blue {ɑ , ɔ , ɔː , m , n}(pronunciation-symbol);
\hspace #1 \italic "To cearly distinguish pronunciation." }
\markup { " " }
\markup { " " }
\markup { " " }
\markup { " " }
\markup { \column { \line {* Modern ballet dancing is OK throughout the entire section}
                  \raise #1 \line { \hspace #2 (You must remain stationary between bars 1 ~ 5 , 18,19 and ?~*).}
				  \raise #2 \line { \hspace#2 However, where there is a rest, the movement should stop in its current state.}
				  \raise #3 \line { \hspace#2 And then exit within 49 bars.} }}
\markup { \vspace #1 }
%%%%%%%%
}%% end bookpart II
\bookpart{ %% III wrting of attention And out of source code
%% \markup { \vspace #6 }
\markup { \hspace #26 \huge "INSTRUMENT RANGES" }
\markup { \hspace #8 \italic "About;" \teeny\italic
"Some of Instruments; there is a difference between
writing-note and real-note."
\italic "for instance:" }
\markup { \hspace #8 \column { \line { \bold %%
           "WOODWINDS; Piccolo(in C)"--\tiny "like this"-- }
\line { \score { { \clef treble \key c\major \time 4/1
 d'1^\markup {\italic "written" } s1 g'''1 s1 \bar"||"
 s2 d''1_\markup { \hspace #-8 \italic "sounds one octave higher" }
 s1  g''''1 s2 | \break
                  }
\layout { \context { \Staff
        \override ClefSignature.transparent = ##t
        \override TimeSignature.transparent = ##t }
           indent = 20.00\mm line-width = 160.00\mm }
                 } }
         }}
\markup { " " }
\markup { \vspace #2 }
\markup { \hspace #8 \column {
\line { \hspace #18.4 \bold "Bass Flute"--\tiny "like this"-- }
\line { \score { {
\clef treble \key c\major \time 4/1
c'1^\markup {\italic "written" } s1 a'''1 s1 \bar"||"
\clef bass s2 c1_\markup {
\hspace #-8 \italic "sounds one octave lower" }
s1 \clef treble a''1 s2| \break
   }
\layout { \context { \Staff
  \override ClefSignature.transparent = ##t
  \override TimeSignature.transparent = ##t }
   indent = 20.00\mm line-width = 160.00\mm }
         } }
                  }}
\markup { " " }
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\markup { \vspace #6 }
\markup { \fill-with-pattern #2 #CENTER - \null \null }
\markup { " " }
\markup { \hspace #20 \magnify #2 {
 Stage Position;\tiny \italic "(This arrangement--with the instrument needles column below--)" } }
\markup { " " }
\markup { \hspace #26 \column { \line { About the Chorus; \teeny \italic "(For instsnce")}
\line { \hspace # 18 \rounded-box {Bass}\hspace #2 \rounded-box {Tenor}\hspace #2 \rounded-box {Alto}\hspace #2
\rounded-box{Soprano} } \teeny \italic " since, They must be reverse for Instrument's arrangement " } }
\markup { \vspace #2 }
\markup { \italic " About Position of Sololist is placed freely(on the stage) " }
\markup { \vspace #2 }
\markup { About Instrument arrangement;\teeny \italic "(must be reverse for Chours's position)" }
\markup { \hspace # 20 \rounded-box { \column { \huge " Instruments " "   Soprano " "   Group "} }\hspace #3
\rounded-box { \column { \huge " Instruments " "   Alto " "   Group "} }\hspace #3
\rounded-box { \column { \huge " Instruments " "   Tenor " "   Group "} }\hspace #3
\rounded-box { \column { \huge " Instruments " "   Bass " "   Group "} } }
\markup { \vspace #2 }
\markup { \hspace #56 \huge " Conductor " }
\markup { " " }
\markup { \vspace #1 }
\markup { \fill-with-pattern #2 #CENTER - \null \null }
\markup { \vspace #2 }
\markup { ........... Audience seats ........... }
\markup { \vspace #4 }
\markup { \teeny { \column { \bold \italic
"If you can do it, please running on;"
\line { \wordwrap {
As it is the lighting of the audience's Seats(Do not turn off even when the play began). \hspace #2 \italic "When play began, lighting the stage (rather than the audience's) more brightly."}}}}}
\markup { "   " }
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\pageBreak
\markup { "  " }
%% eps-part -------------------------------------------------------------------
%% C:\Program Files (x86)\LilyPond\usr\share\ghostscript\8.70\Resource\Init\
%% Fontmap.GS // Not!! [Windows--ghostscript]
#(let* ((port (open-output-file "Source-code.eps")))
  (display "%!PS-Adobe-3.0 EPSF-3.0
%%BoundingBox: 60 227 525 636
%%HiResBoundingBox: 60.20 227.30 524.50 635.60
%%Creator: GPL Ghostscript 922 (eps2write)
%%LanguageLevel: 2
%%CreationDate: D:20180608144500+09'00'
%%Pages: 1
%%EndComments
/Times-Italic findfont 200 scalefont setfont 120 500 moveto 1 0 0 setrgbcolor
(ALL) false charpath 4 setlinewidth stroke

/Times-Italic findfont 120 scalefont setfont 60 320 moveto 0 0 0 setrgbcolor
(SOURCE) false charpath 3 setlinewidth stroke

/Times-Italic findfont 120 scalefont setfont 100 230 moveto 0 0 0 setrgbcolor
(CODE) false charpath 1 setlinewidth stroke"
port)

  (close port))
%Trailer
%% end -----eps part-------------------------------------------------------------------
%%%% Needn't Surce code's Title-String for texi-document.
\markup { \vspace #10 }
\markup { \hspace #12 \epsfile #X #100 #"Source-code.eps" }
\markup { " " }
\markup { \vspace #1 }
\markup { \fill-line { \center-column {
\line { As all;\hspace #2 See! (HTML) @menu }
"https://www.sheet-poem.com/poem/html/2024/2.24.0/departure/departure.html" } } }
\pageBreak
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
}}%% end bokkpart III, End book
%%%%%%%%%%%%%%%%%%%% All End %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%% exclude. %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% \markup { \column { "Name; departure.ly"                   %%%%
%%%%%            \verbatim-file #"departure.ly" } }             %%%%
%%%%%  \markup { \column { "Name; departure-cv.ly"               %%%%
%%%%%            \verbatim-file #"departure-cv.ly" } }           %%%%
%%%%%  \markup { \column { "Name; run--lily.sh"      %%%%
%%%%%            \verbatim-file #"run--lily.sh" } }  %%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
